﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace _2JigenKaitenProgram
{
    internal class Vector2D
    {
        /// <summary>
        /// X座標
        /// </summary>
        public double X { get; set; }

        /// <summary>
        /// Y座標
        /// </summary>
        public double Y { get; set; }

        /// <summary>
        /// デフォルトコンストラクタ（座標を0で初期化）
        /// </summary>
        public Vector2D()
        {
            X = 0;
            Y = 0;
        }

        /// <summary>
        /// コンストラクタ（指定した座標で初期化）
        /// </summary>
        /// <param name="x">x座標</param>
        /// <param name="y">y座標</param>
        public Vector2D(double x = 0, double y = 0)
        {
            X = x;
            Y = y;
        }

        /// <summary>
        /// ベクトルの加算（a + b）
        /// </summary>
        /// <param name="a">ベクトルA</param>
        /// <param name="b">ベクトルB</param>
        /// <returns>加算結果のベクトル</returns>
        public static Vector2D operator +(Vector2D a, Vector2D b)
        {
            return new Vector2D(a.X + b.X, a.Y + b.Y);
        }

        /// <summary>
        /// ベクトルの減算（a - b）
        /// </summary>
        /// <param name="a">ベクトルA</param>
        /// <param name="b">ベクトルB</param>
        /// <returns>減算結果のベクトル</returns>
        public static Vector2D operator -(Vector2D a, Vector2D b)
        {
            return new Vector2D(a.X - b.X, a.Y - b.Y);
        }

        /// <summary>
        /// スカラー倍（v * scalar）
        /// </summary>
        /// <param name="v">ベクトル</param>
        /// <param name="scalar">スカラー値</param>
        /// <returns>スカラー倍されたベクトル</returns>
        public static Vector2D operator *(Vector2D v, double scalar)
        {
            return new Vector2D(v.X * scalar, v.Y * scalar);
        }

        /// <summary>
        /// スカラー倍（scalar * v）
        /// </summary>
        /// <param name="scalar">スカラー値</param>
        /// <param name="v">ベクトル</param>
        /// <returns>スカラー倍されたベクトル</returns>
        public static Vector2D operator *(double scalar, Vector2D v)
        {
            return v * scalar;
        }

        /// <summary>
        /// スカラー除算（v / scalar）
        /// </summary>
        /// <param name="v">ベクトル</param>
        /// <param name="scalar">スカラー値</param>
        /// <returns>除算結果のベクトル</returns>
        public static Vector2D operator /(Vector2D v, double scalar)
        {
            return new Vector2D(v.X / scalar, v.Y / scalar);
        }

        /// <summary>
        /// 内積を計算する
        /// </summary>
        /// <param name="other">もう一方のベクトル</param>
        /// <returns>内積の値</returns>
        public double Dot(Vector2D other)
        {
            return this.X * other.X + this.Y * other.Y;
        }

        /// <summary>
        /// ベクトルの長さを計算する
        /// </summary>
        /// <returns>ベクトルの長さ</returns>
        public double Length()
        {
            return Math.Sqrt(X * X + Y * Y);
        }

        /// <summary>
        /// ベクトルを正規化（単位ベクトル化）する
        /// </summary>
        /// <returns>正規化されたベクトル</returns>
        public Vector2D Normalize()
        {
            double len = Length();
            if (len == 0) return new Vector2D(0, 0);
            return new Vector2D(X / len, Y / len);
        }

        /// <summary>
        /// ベクトルを文字列に変換する
        /// </summary>
        /// <returns>(X, Y)形式の文字列</returns>
        public override string ToString()
        {
            return $"({X}, {Y})";
        }
    }
}