# GraphicBox2D ReadMe

## 公式リファレンスサイト
https://kanineko.com/graphic2dcontroltop/

## 日本語

### 使い方

1. インストール後、ツールボックスを右クリックして **「アイテムの選択」** をクリックし、以下のコントロールを追加してください。  
   packages\lib\net472\graphicbox2d.dll
   

2. ツールボックスから **「Graphic2DControl」** をドラッグしてフォームに貼り付けてください。

3. 以下のサンプルソースを使って、「Graphic2DControl」内に図形を描画しましょう。

```csharp
// Point
Point2D point = new Point2D();
point.X = -1;
point.Y = -1;
this.graphic2DControl1.Points.Add(point);

// Circle
Circle2D circle = new Circle2D();
circle.X = 3;
circle.Y = 3;
circle.R = 1.0f;
circle.IsFilled = false;
circle.Color = Color.Red;
this.graphic2DControl1.Circles.Add(circle);

// Polygon
Polygon2D polygon2D = new Polygon2D();
polygon2D.IsFilled = true;
polygon2D.Color = Color.Green;
polygon2D.Points.Add(new PointF(-2, 2));
polygon2D.Points.Add(new PointF(-1, 4));
polygon2D.Points.Add(new PointF(0, 2));
this.graphic2DControl1.Polygons.Add(polygon2D);

// Arrow
Arrow2D arrow = new Arrow2D();
arrow.Start = new Point(0, 0);
arrow.End = new Point(3, 3);
arrow.Color = Color.Yellow;
this.graphic2DControl1.Arrows.Add(arrow);

// Text : Welcome
Text2D text = new Text2D();
text.X = -3;
text.Y = -3;
text.FontSize = 16.0f;
text.Text = "ようこそ、3D数学";
text.Angle = 30.0f;
this.graphic2DControl1.Texts.Add(text);

// Text : Angle
Text2D text2 = new Text2D();
text2.X = 0.4f;
text2.Y = 0.4f;
text2.FontSize = 11.0f;
text2.Text = "45°";
text2.Color = Color.Cyan;
this.graphic2DControl1.Texts.Add(text2);

// Text : cosθ
Text2D text3 = new Text2D();
text3.X = 1.5f;
text3.Y = 1.0f;
text3.FontSize = 16.0f;
text3.Text = "cosθ";
this.graphic2DControl1.Texts.Add(text3);

// Arc
Arc2D arc = new Arc2D();
arc.X = 0;
arc.Y = 0;
arc.R = 1.0f;
arc.StartAngle = 0f;
arc.EndAngle = 45.0f;
arc.IsFilled = false;
arc.Color = Color.Cyan;
this.graphic2DControl1.Arcs.Add(arc);

// Graph
Graph2D graph = new Graph2D();
graph.Susiki = "cos(x)";
graph.StartX = -5.0f;
graph.EndX = 5.0f;
graph.Color = Color.White;
graph.CalculateInterval = 0.05f;
graph.CalculateGraphPoints();
this.graphic2DControl1.Graphs.Add(graph);

// Redraw
this.graphic2DControl1.Invalidate();


## English

### Usage

1. After installation, right-click the **Toolbox** and select **"Choose Items"**, then add the following control:  
   packages\lib\net472\graphicbox2d.dll

2. Drag **"Graphic2DControl"** from the Toolbox and drop it onto your form.

3. Use the following sample code to draw shapes inside the `Graphic2DControl`.

```csharp
// Point
Point2D point = new Point2D();
point.X = -1;
point.Y = -1;
this.graphic2DControl1.Points.Add(point);

// Circle
Circle2D circle = new Circle2D();
circle.X = 3;
circle.Y = 3;
circle.R = 1.0f;
circle.IsFilled = false;
circle.Color = Color.Red;
this.graphic2DControl1.Circles.Add(circle);

// Polygon
Polygon2D polygon2D = new Polygon2D();
polygon2D.IsFilled = true;
polygon2D.Color = Color.Green;
polygon2D.Points.Add(new PointF(-2, 2));
polygon2D.Points.Add(new PointF(-1, 4));
polygon2D.Points.Add(new PointF(0, 2));
this.graphic2DControl1.Polygons.Add(polygon2D);

// Arrow
Arrow2D arrow = new Arrow2D();
arrow.Start = new Point(0, 0);
arrow.End = new Point(3, 3);
arrow.Color = Color.Yellow;
this.graphic2DControl1.Arrows.Add(arrow);

// Text : Welcome
Text2D text = new Text2D();
text.X = -3;
text.Y = -3;
text.FontSize = 16.0f;
text.Text = "Welcome to 3D Math";
text.Angle = 30.0f;
this.graphic2DControl1.Texts.Add(text);

// Arc
Arc2D arc = new Arc2D();
arc.X = 0;
arc.Y = 0;
arc.R = 1.0f;
arc.StartAngle = 0f;
arc.EndAngle = 45.0f;
arc.IsFilled = false;
arc.Color = Color.Cyan;
this.graphic2DControl1.Arcs.Add(arc);

// Graph
Graph2D graph = new Graph2D();
graph.Susiki = "cos(x)";
graph.StartX = -5.0f;
graph.EndX = 5.0f;
graph.Color = Color.White;
graph.CalculateInterval = 0.05f;
graph.CalculateGraphPoints();
this.graphic2DControl1.Graphs.Add(graph);

// Redraw
this.graphic2DControl1.Invalidate();